#import( class , CS_ParseMail )
#import( class , CS_RulesResult )

#define NULL 0
#define true 1
#define false 0

#define CONTINUE_SCRIPT 0
#define EXIT_AND_DROP   1

//LOG
#define LOGL0   0 // no log
#define LOGL1   1 
#define LOGL2   2 
#define LOGL3   3 
#define LOGALL  4 // 1+2+3 + DEBUG

//RE
#define RE_CASELESS  1
#define RE_MULTILINE 2
#define RE_DOTALL    4
#define RE_EXTENDED  8

//STATISTIC
#define	MOREMORE    1
#define	LESSLESS    2
#define	EQUAL_VALUE 3
#define	MORE_VALUE  4
#define	LESS_VALUE  5
#define	MAX_VALUE   6
#define	MIN_VALUE   7


// SPF RESULT
#define SPF_Pass                 0   // + (permitted to send mail)
#define SPF_SoftFail             1   // ~ (not permitted to send mail, but do not reject mail)
#define SPF_Fail                 2   // - (not permitted to send mail)
#define SPF_Neutral              3   // ? (neither permitted not denied to send mail)
#define SPF_None                 4   // no SPF record
#define SPF_TempError            5   // temporary error (error retrieving data from DNS)
#define SPF_PermError            6   // permanent error (unknown mechanism or syntax error)


// LOCAL DOMAIN PROPERTY		
#define LD_ED_GREYLIST     1
#define LD_ED_MAILER_DEMON 2
#define LD_ED_BAYES_FILTER 4
#define LD_ED_HELO	   8
#define LD_ED_NSBL_SCORE   16
#define LD_ED_HONEYPOT     32
#define LD_ED_MAR_SUBJECT  64
#define LD_ED_MAR_HEADER   128
#define LD_ED_MAR_REJECT   256
#define LD_ED_RULES        512
#define LD_ED_ALWL         1024
#define LD_ED_PHISHING     2048
#define LD_ED_WEB_ENABLE   4096
#define LD_ED_DANTE_COMM   8192


//BAYES
#define BAYES_IS_SPAM             1
#define BAYES_IS_HAM              2
#define	BAYES_IS_NEUTRAL          3
#define	BAYES_IS_NEUTRAL_TO_LEARN 4


CS_ANTISPAM_SCRIPT this = new CS_ANTISPAM_SCRIPT($_this);

int     m_id_connection = 0;
int     m_relay = -1;
string  m_ip_client = "";
string  m_helo = "";
string  m_rfc_mailfrom = "";
string  m_rfc_rcptto = "";
int     m_spf_result = -1;
int     m_cmd_noop = 0;
int     m_wbl = -1;
int     m_spamlover = -1;
int     m_alwl = -1;
float   m_total_score = 0.0;
float   m_score_level_zero = 0.0;
string  m_bayes_header_msg = "";
string  m_phishing_header_msg = "";

// Event variable Notification
// call from other scripts

this->RegisterGlobalVariable("core_relay");
this->RegisterGlobalVariable("core_total_score");
this->RegisterGlobalVariable("core_spf_result");
this->RegisterGlobalVariable("core_wbl");
this->RegisterGlobalVariable("core_alwl");
this->RegisterGlobalVariable("core_spamlover");
this->RegisterGlobalVariable("notify_email_is");
this->RegisterGlobalVariable("notify_email_cause_rejected");
this->RegisterGlobalVariable("notify_greylist_action");
this->RegisterGlobalVariable("notify_bayes");
this->RegisterGlobalVariable("notify_phishing");



void NotificationGlobalVariable(string name, string value)
{
 
 if (name == "core_relay")
     m_relay = this->CharToInt(value); //riceve Notification
 
 if (name == "core_total_score")
     m_total_score += this->CharToFloat(value); //send and riceve Notification 

 if (name == "core_spf_result")
     m_spf_result = this->CharToInt(value); //send and riceve Notification 

 if (name == "core_wbl")
     m_wbl = this->CharToInt(value); //send and riceve Notification 

 if (name == "core_alwl")
     m_alwl = this->CharToInt(value); //send and riceve Notification 

 if (name == "core_spamlover")
     m_spamlover = this->CharToInt(value); //send and riceve Notification 

}
//////////////

// INTERNAL FUNCTION
void Reset()
{
   
   m_bayes_header_msg = "";
   m_phishing_header_msg = "";
   m_rfc_mailfrom = "";
   m_rfc_rcptto = "";
   m_spf_result = -1;
   m_wbl = -1;
   m_spamlover = -1;
   m_alwl = -1;
   m_total_score = m_score_level_zero;

}


void DropConnection(string msg,string rfc_node)
{
    string tmp = this->Format(this->GetConfig(rfc_node), msg);
    this->WriteLog(LOGL2, "THIS IS SPAM : cl-> " + tmp,"SYS");
    this->SendToClient( tmp + "\r\n" );
    this->CloseClientConnAfterSendingQueue();
    this->DropBufferToMTA();
    this->SetGlobalVariable("notify_email_is","REJECTED"); 

}


// PROXY ENGINE FUNCTION
int OnStartClientConnection(int id_connection)
{

 m_id_connection = id_connection;
 m_ip_client     = this->GetClientIP();
 this->RegisterSessionIp(m_ip_client);

 if (this->IsIpInferno(m_ip_client))
 {
	this->WriteLog(LOGL1, "Drop connection IP Inferno: " + m_ip_client, "FIREWALL");
        this->SetGlobalVariable("notify_email_cause_rejected","ipinferno");
        DropConnection(" Embargo ", "rfc554");
	this->StatisticValue("f3fw_iphell_[" + m_ip_client +"]",3,0,1,MOREMORE);
	return CONTINUE_SCRIPT; 	
 }

  if (m_relay == -1)
     m_relay = this->ClientIsRelay();

  if (m_relay)
  {
    this->StatisticValue("f3fw_iprelay_[" + m_ip_client + "]",3,0,1,MOREMORE);
    this->WriteLog(LOGL1, "RELAY IP: TRUE","SYS");
  } else 
     this->WriteLog(LOGL1, "RELAY IP: FALSE","SYS");



  // DNSBL;
  if (this->CharToInt(this->GetConfig("enable_dnsbl")) == true && (this->IsIpWhiteList(m_ip_client) == false || m_relay == false))
   {
         
          m_score_level_zero = this->DNSBL_Score(m_ip_client);
          string dnsbltxt = this->DNSBL_Ns(m_ip_client);

	  int hits = 0;

	  this->WriteLog(LOGL1, this->Format("FILTER DNSBL IP [%s]: %.3f",m_ip_client, m_score_level_zero),"SYS");
	  this->StatisticValue("f6_tot-dnsbl",6,0,1,MOREMORE);
	  
	  if (m_score_level_zero > 0.0f)
	  {
		this->WriteLog(LOGL1, this->Format("FILTER DNSBL : %s",dnsbltxt),"SYS");
		int count_dnsbl_maxreplies = this->CharToInt(this->GetConfig("maxreplies","DNSBL")) + 1;
		string nsbl_provider;

		for (int i = 0; i < count_dnsbl_maxreplies; i++)
		{
		nsbl_provider = this->Split(dnsbltxt,' ',i);
		if (nsbl_provider == "") 
                     break;	
		this->StatisticValue("f6_dnsbl_[" + nsbl_provider + "]",6,0,1,MOREMORE);
		hits++;
		}
	  }
	m_total_score += m_score_level_zero;

	if (this->CharToInt(this->GetConfig("reject_dnsbl")) == true && hits >= this->CharToInt(this->GetConfig("maxhit","DNSBL")))
	 {
	       this->WriteLog(LOGL1, "Drop connection DNSBL IP: " + m_ip_client +  " LIST: " + dnsbltxt, "SYS");
               this->SetGlobalVariable("notify_email_cause_rejected","dnsbl");
	       DropConnection("IP in the DNSBL " + dnsbltxt + " ", "rfc554");
	       this->StatisticValue("f6_reject-dnsbl",6,0,1,MOREMORE);
	       return CONTINUE_SCRIPT;
	  }
  }

  // max session for IP
  if (!m_relay)
   {
    if (this->IsIpMaxSession(m_ip_client))
     {
	this->WriteLog(LOGL1, "Max Session from IP: " + m_ip_client, "FIREWALL");
        this->SetGlobalVariable("notify_email_cause_rejected","maxsession");
	DropConnection(this->GetConfig("myname"),"rfc421");	
	this->StatisticValue("f3fw_session_max_ip",3,0,1,MOREMORE);
	return CONTINUE_SCRIPT;	    
     }
   }
  


 if (this->ConnectToDefaultMTA())
 {
  this->DropExtensionMTA("250-PIPELINING\r\n");
  this->DropExtensionMTA("250-CHUNKING\r\n");
  this->DropExtensionMTA("250-STARTTLS\r\n");


  return CONTINUE_SCRIPT; 
 } 


 this->SendToClient( this->Format(this->GetConfig("rfc421"),this->GetConfig("myname")) + "\r\n" );
 this->CloseClientConnAfterSendingQueue();	 

 return CONTINUE_SCRIPT; 	
}

int OnReplyMTA(string buffer)
{
  
 
  // REPLACE
  if (this->REeq(buffer,this->GetConfig("myname") + "|" + this->GetConfig("myippub") ,RE_CASELESS + RE_MULTILINE) == true)
  {
	if (this->GetClientReverseDns() != "")
	{
	 //SENDMAIL HELO/EHLO replace
	 buffer = this->Replace(buffer,this->GetConfig("myname") + " [" + this->GetConfig("myippub") + "]", this->GetClientReverseDns() + " [" + m_ip_client + "]");
	}
	else {
		  //SENDMAIL HELO/EHLO replace
		  buffer = this->Replace(buffer,this->GetConfig("myname") + " [" + this->GetConfig("myippub") + "]", "[" + m_ip_client + "]"); 
		 }
	

   this->DropBufferToClient();
   this->SendToClient(buffer);

  }

   // 250-STAY WAY hostname
   // 250- hostname pleased to meet you
   if (this->REeq(buffer,"^5[0-9]",RE_CASELESS) == 0 && this->GetReplaceNameServerMTA() != "")
   {
     buffer = this->Replace(buffer,this->GetNameServerMTA(),this->GetReplaceNameServerMTA());
     this->DropBufferToClient();
     this->SendToClient(buffer);
   }

  return CONTINUE_SCRIPT;
}

/////////

void OnAuthenticatedToMTA()
{
 m_relay = true;
}


void OnHelo(string helo, string helotype)
{
 m_helo = helo;
}

void OnMailFrom(string mailfrom)
{

  m_rfc_mailfrom = mailfrom;

  //check for helo forged
  if (!m_relay && this->CharToInt(this->GetConfig("helo_forget_reject")) == true && this->IsForgetHelo(m_helo) == true)
  {
    this->SetGlobalVariable("notify_email_cause_rejected","heloforget");
    DropConnection(" Helo invalid or forged ","rfc550"); 			
    this->StatisticValue("f1tot_msg_spam",1,0,1,MOREMORE);
    this->StatisticValue("f9_helo_forged",9,0,1,MOREMORE);
    return;
 }
 
 // SPF
 if (!m_relay && this->CharToInt(this->GetConfig("spf_enable")) == true && !this->IsLanIp(m_ip_client))
  {
      if (m_spf_result == -1)
         m_spf_result = this->SPFQuery(m_ip_client,m_rfc_mailfrom,m_helo);
      this->WriteLog(LOGL1, "SPF Result: " + this->SPFResultString(m_spf_result),"SYS");
      this->StatisticValue(this->Format("f1_spf_[%s]",this->SPFResultString(m_spf_result)),18,0,1,MOREMORE);

      this->SetGlobalVariable("core_spf_result",this->Format("%d",m_spf_result));

      if (m_spf_result == SPF_Fail && this->CharToInt(this->GetConfig("spf_reject_fail")) == true)
      {
	this->SetGlobalVariable("notify_email_cause_rejected","spffail");
        DropConnection(" SPF MAIL-FROM check failed ","rfc550"); 
        this->StatisticValue("f1tot_msg_spam",1,0,1,MOREMORE);
        return; 
      }
   
  } else {
   m_spf_result = SPF_None;
   if (this->CharToInt(this->GetConfig("spf_enable")) == true)
      this->WriteLog(LOGL1, "SPF Result: NONE... Relay or private IP","SYS");
  }


}

void OnRcptToError(string rcptto)
{
  //realy attempt ?
  if (!m_relay && this->REeq(rcptto,"[\\!\\%\\@]\\S*\\@",0) == true )
  {
   this->WriteLog(LOGL1, "RELAY : cl->" + this->GetConfig("rfc530"),"SYS");
   this->WriteLog(LOGL2, "RELAY ATTEMPT: " +  rcptto,"SYS"); 
   this->DropBufferToMTA();
   this->SendToClient( this->GetConfig("rfc530") + "\r\n" );
  }

  this->SetErrorCountRFC(this->GetErrorCountRFC() + 1);
}


void OnRcptTo(string rcptto)
{
  int tmp_property =  this->IsLocalDomainByRCPT_TO(rcptto);

  if (!m_relay && tmp_property == -1)
    {
     this->WriteLog(LOGL1, "RELAY : cl->" + this->GetConfig("rfc530"),"SYS");
     this->WriteLog(LOGL2, "RELAY ATTEMPT: " +  rcptto,"SYS"); 
     this->DropBufferToMTA();
     this->SendToClient( this->GetConfig("rfc530") +"\r\n" );
     this->SetErrorCountRFC(this->GetErrorCountRFC() + 1);
      return;
    } else {
	    this->RegisterSessionProperty(tmp_property);
	   }



   //LD_ED_MAILER_DEMON
   if (!m_relay && this->GetSessionProperty() & LD_ED_MAILER_DEMON)
   {
	string tuser = this->Lc(this->Split(rcptto,'@',0));
	if (tuser == "postmaster" || tuser == "mailer-daemon" || this->StrLen(m_rfc_mailfrom) == 0)
	{
	 this->WriteLog(LOGL1, "DISABLED Bounce Senders : cl-> 550 5.1.1 <" + rcptto + ">... User unknown","SYS");
	 this->DropBufferToMTA(); 
	 this->SendToClient("550 5.1.1 <" + rcptto + ">... User unknown\r\n");
	 this->SetErrorCountRFC(this->GetErrorCountRFC() + 1);
         return;
	}
  }
  
  //SPAM TRAP HONEYPOT
  if (this->IsSpamTrap(rcptto) == true)
  {
    this->StatisticValue("f1tot_msg_spam",1,0,1,MOREMORE);
    this->StatisticValue("f1tot_msg_spamtrap",1,0,1,MOREMORE);
    this->WriteLog(LOGL1, "SPAM TRAP !!!","SYS");
    
    //Dante Community;
    if (this->StrLen(m_rfc_mailfrom) > 0 && this->IsValidKeyDanteCommunity() && m_spf_result != SPF_Fail)
    {
      this->WriteLog(LOGL3, "SEND SPAM TRAP TO COMMUNITY","SYS"); 
      this->DanteCommunityAnnunce(m_ip_client,this->GetClientReverseDns(),m_rfc_mailfrom);
      this->StatisticValue("f1_dante_[spamtrap]",19,0,1,MOREMORE);
    }

    
    this->SendToClient( this->GetSpamTrapResponse() );
    this->CloseClientConnAfterSendingQueue();
    this->DropBufferToMTA();
    this->SetGlobalVariable("notify_email_cause_rejected","spamtrap");
    this->SetGlobalVariable("notify_email_is","REJECTED");
    return;
  }

  if (this->StrLen(m_rfc_rcptto) == 0)
    m_rfc_rcptto += rcptto;
  else
   m_rfc_rcptto += " " + rcptto;

}

void OnCommandNOOP()
{
  m_cmd_noop++;

  if (m_cmd_noop > this->CharToInt(this->GetConfig("cmd_noop","FIREWALL")))
  {
   this->WriteLog(LOGL1, this->Format("Max Command NOOP : %d",m_cmd_noop),"FIREWALL");
   this->StatisticValue("f3fw_max_noop",3,0,1,MOREMORE);
   this->SetGlobalVariable("notify_email_cause_rejected","maxcommandnoop");
   DropConnection("Connection blocked max command noop","rfc550");
   return;
  }

}

void OnCommandRSET()
{
   
   Reset();

   this->SetErrorCountRFC(this->GetErrorCountRFC() + 1);

  if (this->GetErrorCountRFC() > this->CharToInt(this->GetConfig("error_max","FIREWALL")))
  {
   this->WriteLog(LOGL1, this->Format("Max Command RSET : %d",this->GetErrorCountRFC()),"FIREWALL");
   this->StatisticValue("f3fw_max_errore",3,0,1,MOREMORE);
   this->SetGlobalVariable("notify_email_cause_rejected","maxcommandrset");
   DropConnection("Connection blocked max command RSET","rfc550");
   return;
  }
  
}

void OnCommandData(int max_len)
{
  
  if (m_wbl == -1)
     m_wbl = this->IsWhiteBlackList(m_rfc_rcptto,m_rfc_mailfrom);
  
  if (m_wbl == 0)
  {
    this->WriteLog(LOGL1, "WHITE LIST", "SYS");
    this->SetGlobalVariable("core_wbl",this->Format("%d",m_wbl));
  }
  
  if (m_spamlover == -1)
     m_spamlover = this->IsSpamLover(m_rfc_rcptto);

  if (m_spamlover)
  {
   this->WriteLog(LOGL1, "SPAM LOVER","SYS");
   this->SetGlobalVariable("core_spamlover",this->Format("%d",m_spamlover));
  }


  // AutoLightWhiteList
  if (this->GetSessionProperty() & LD_ED_ALWL)
  {
    if (m_relay)
    {
      this->AddALWL(m_rfc_mailfrom,m_rfc_rcptto);
      m_alwl = 0;
    }
    else
     {
      if (m_alwl == -1)
      {
      m_alwl = this->IsALWL(m_rfc_mailfrom,m_rfc_rcptto);
      this->SetGlobalVariable("core_alwl",this->Format("%d",m_alwl)); 
      }
     }
  } else {
          m_alwl = 0;
	 }

  //BLACK LIST !!
  if (m_wbl == 1 && !m_spamlover) // SPAMLOVER conflict !!! behavior is not good
  {
    this->SetGlobalVariable("core_wbl",this->Format("%d",m_wbl));
    this->WriteLog(LOGL1, "Black List Email " + m_rfc_mailfrom,"SYS");
    this->StatisticValue("f1tot_msg_spam",1,0,1,MOREMORE);
    this->SetGlobalVariable("notify_email_cause_rejected","blacklist");
    DropConnection("Message rejected by domain policy. Black List Email " + m_rfc_mailfrom,"rfc554");
    return;
  }

  // HELO rfc 1123
  if (!m_relay && this->GetSessionProperty() & LD_ED_HELO && m_wbl != 0 && !m_spamlover)
  {
   //RFC OK ? (.tld and .local)
   if (!this->REeq(m_helo,"^(([a-z\\d][a-z\\d\\-]*)?[a-z\\d]\\.)+[a-z]{2,32}$",RE_CASELESS))
    {
     //IPv4
     if (this->REeq(m_helo,"^\\[\\d+\\.\\d+\\.\\d+\\.\\d+\\]$",RE_CASELESS))
     {
      this->WriteLog(LOGL1, "FILTER HELO RFC1123 : " + this->GetConfig("helo_ip"),"SYS");
      m_total_score += this->CharToFloat(this->GetConfig("helo_ip"));
      this->StatisticValue("f9_helo_ip",9,0,1,MOREMORE);
     }
     else
       {
        this->WriteLog(LOGL1, "FILTER HELO RFC1123 : " + this->GetConfig("helo_rfc"),"SYS");
        m_total_score += this->CharToFloat(this->GetConfig("helo_rfc"));
        this->StatisticValue("f9_helo_invalid",9,0,1,MOREMORE);
       }
    }

   //FORGED HELO no REJECT?
   if (this->IsForgetHelo(m_helo))
   {
     m_total_score += this->CharToFloat(this->GetConfig("p_helo_forget"));
     this->WriteLog(LOGL1,  "FILTER HELO FORGED : " + this->GetConfig("p_helo_forget"),"SYS");
     this->StatisticValue("f9_helo_forged",9,0,1,MOREMORE);
   }
		   
  }

  //GREY LIST
  // AUTOMATIC STATISTIC by internal Function
  if (!m_relay && this->GetSessionProperty() & LD_ED_GREYLIST && m_wbl != 0 && !m_alwl && !m_spamlover && !this->IsWhiteIpGreyList(m_ip_client))
  {
    string triples = this->PrepareTriplesGreyList(m_rfc_rcptto,m_ip_client,m_rfc_mailfrom,m_helo,this->GetClientReverseDns());

    if (this->PassGreyList(triples))
    {
      int forged_count_greylist = this->GetForgedCountGreyList(triples);
      float score_forged = (this->CharToFloat(this->GetConfig("grey_forged_score")) * forged_count_greylist);
      this->WriteLog(LOGL2, this->Format("GREY LIST FORGED n.%d SCORE: %.3f",forged_count_greylist,score_forged),"SYS");
      m_total_score += score_forged;
      this->ResetForgedCountGreyList(triples);
      this->WriteLog(LOGL1, "Grey List O.k !!! ","SYS");
      this->SetGlobalVariable("notify_greylist_action","PASS");
    }
     else
    {
     this->AddToGreyList(triples);
     this->WriteLog(LOGL1, "Add Greylist for later (triples: " + m_ip_client + " " + m_rfc_mailfrom + " -> " + m_rfc_rcptto + " )","SYS");
     this->SendToClient( this->GetConfig("rfc451") + "\r\n" );
     this->DropBufferToMTA();
     this->SetGlobalVariable("notify_greylist_action","FAIL");
     return;
     }
			
  }


}


void OnEmailMessagesToAnalyzer()
{
   string bayes_header_msg = "NONE";
   string phishing_header_msg = "NONE";
 
   this->StatisticValue("f1tot_msg",1,0,1,MOREMORE);

   //LD_ED_MAILER_DEMON HEADER Messages
   if (!m_relay && this->GetSessionProperty() & LD_ED_MAILER_DEMON)
   {
	string tuser = this->Lc(this->Split(this->GetEmailMailFrom(),'@',0));
	if (tuser == "postmaster" || tuser == "mailer-daemon")
	{
	 string tmp = this->Format(this->GetConfig("rfc554"),"Message rejected by domain policy. BOUNCER NOT ALLOW");
	 this->WriteLog(LOGL1, tmp,"SYS");
         this->SendToClient( tmp + "\r\n" );
	 this->CloseClientConnAfterSendingQueue();
         this->DropBufferToMTA();
         this->StatisticValue("f1bouncer_msg_rejected",1,0,1,MOREMORE);
         this->SetGlobalVariable("notify_email_cause_rejected","bouncer");
         this->SetGlobalVariable("notify_email_is","REJECTED");
	 return;
	}
   }

   //BAYES
   int bayes_res = this->BayesianCheck();
   this->AddToBayesianQuarantine(m_rfc_mailfrom, m_rfc_rcptto, bayes_res);
   if (!m_relay && this->GetSessionProperty() & LD_ED_BAYES_FILTER)
    {
     
     if (bayes_res == BAYES_IS_HAM)
      {
	this->WriteLog(LOGL1, "FILTER BAYES : " + this->GetConfig("p_bayes_ham"),"SYS");
	m_total_score += this->CharToFloat(this->GetConfig("p_bayes_ham"));
        m_bayes_header_msg = "HAM";
      }
     
     if (bayes_res == BAYES_IS_SPAM)
      {
	this->WriteLog(LOGL1, "FILTER BAYES : " + this->GetConfig("p_bayes_spam"),"SYS");
	m_total_score += this->CharToFloat(this->GetConfig("p_bayes_spam"));
        m_bayes_header_msg= "SPAM";
      }	
     if (bayes_res == BAYES_IS_NEUTRAL)
      {
	this->WriteLog(LOGL1, "FILTER BAYES : 0.000 NEUTRAL","SYS");
        m_bayes_header_msg = "NEUTRAL";
      }
     if (bayes_res == BAYES_IS_NEUTRAL_TO_LEARN)
      {
	this->WriteLog(LOGL1, "FILTER BAYES : 0.000 To LEARN","SYS");
        m_bayes_header_msg = "LEARN";
      }	
     this->SetGlobalVariable("notify_bayes",m_bayes_header_msg); 
    }

    // RULES
    if (!m_relay && this->GetSessionProperty() & LD_ED_RULES)
    {

       CS_RulesResult pRulesRes = new CS_RulesResult();
       float RulesScore = this->RegularExpressionCheck(NULL,pRulesRes);

       this->WriteLog(LOGL1, this->Format("FILTER RULES : %.3f",RulesScore),"SYS");
       m_total_score +=	RulesScore;

       for (int r = 0; r < pRulesRes->GetRulesCount(); r++)
       {
	this->WriteLog(LOGL3, this->Format("FILTER RULES : %s = %.3f ",pRulesRes->GetRulesName(r),pRulesRes->GetRulesScore(r) ),"SYS");
	this->StatisticValue("f12_rules_[" + pRulesRes->GetRulesName(r) +"]",12,0,1,MOREMORE);
       }
       delete pRulesRes;
    }

    //PHISHING
    if (!m_relay && this->GetSessionProperty() & LD_ED_PHISHING)
    {
     if (this->IsPhishing())
     {
	 this->WriteLog(LOGL1, this->Format("PHISHING : %s score %s",this->GetFakePhishingDomain(), this->GetConfig("phishing_score")),"SYS");
	 this->StatisticValue(this->Format("f20phishing_[%s]",this->GetFakePhishingDomain()),20,0,1,MOREMORE);
	 m_total_score += this->CharToFloat(this->GetConfig("phishing_score"));
         m_phishing_header_msg = "TRUE";
      } else {
	      this->WriteLog(LOGL1, "PHISHING : score 0.000","SYS");
               m_phishing_header_msg = "FALSE";
	     }
     this->SetGlobalVariable("notify_phishing",m_phishing_header_msg); 
    }

    // ALWL
    if (m_alwl)
    {
     m_total_score += this->CharToFloat(this->GetConfig("alwl_score")); //NEGATIVE SCORE !!!
     this->StatisticValue("f10_alwl",10,0,1,MOREMORE);
     this->WriteLog(LOGL3, "ALWL : " + this->GetConfig("alwl_score") ,"SYS");
    }

    //DANTE COMMUNITY
    if (!m_relay && m_rfc_mailfrom != "" && this->IsValidKeyDanteCommunity() && this->GetSessionProperty() & LD_ED_DANTE_COMM)
    {
      float score_cmy =  this->DanteCommunityQuery(m_ip_client,this->GetClientReverseDns(),m_rfc_mailfrom);
      this->WriteLog(LOGL3, this->Format("DANTE COMMUNITY : %.3f",score_cmy),"SYS");
      this->StatisticValue(this->Format("f1_dante_[%s]",this->DanteCommunityGetEnumStringFormScore(score_cmy)),19,0,1,MOREMORE);
      m_total_score += score_cmy;
    }
  
   // SPF Score
   if (!m_relay && this->CharToInt(this->GetConfig("spf_enable")) == true)
   {
      if (m_spf_result == SPF_Fail)
      {
        m_total_score +=  this->CharToFloat(this->GetConfig("spf_score_fail"));
        this->WriteLog(LOGL3,"SPF SCORE: " + this->GetConfig("spf_score_fail") + " " + this->SPFResultString(m_spf_result),"SYS");
      } 
       else  if (m_spf_result == SPF_SoftFail)
      {
	m_total_score +=  this->CharToFloat(this->GetConfig("spf_score_softfail"));
	this->WriteLog(LOGL3,"SPF SCORE: " + this->GetConfig("spf_score_softfail") + " " + this->SPFResultString(m_spf_result),"SYS");
      } 
       else  if (m_spf_result == SPF_Pass)
      {
       m_total_score +=  this->CharToFloat(this->GetConfig("spf_score_pass"));
       this->WriteLog(LOGL3,"SPF SCORE: " + this->GetConfig("spf_score_pass") + " " + this->SPFResultString(m_spf_result),"SYS");
      } 
       else 
      {
       this->WriteLog(LOGL3, "SPF SCORE: 0.000 " + this->SPFResultString(m_spf_result),"SYS");
      }
  }


  // for plugin or other script
  this->SetGlobalVariable("core_total_score",this->Format("%f",m_total_score));


}

void OnDoneAntispamFilter()
{

  ///////////// !!!! THE END !!!! /////////////
  this->WriteLog(LOGL3, this->Format("Calcolate score by user [Before: %.3f]",m_total_score),"SYS");
  m_total_score = this->RecalculatingScoreByUser(m_total_score,this->CharToFloat(this->GetConfig("score_for_spam")),m_rfc_rcptto);
  this->WriteLog(LOGL3, this->Format("Calcolate score by user [After: %.3f]",m_total_score),"SYS");

		 
  if (m_total_score >= this->CharToFloat(this->GetConfig("score_for_spam")) && !m_relay && !m_spamlover && m_wbl != 0)
  {
    this->StatisticValue("f1tot_msg_spam",1,0,1,MOREMORE);
    this->SetGlobalVariable("notify_email_is","SPAM");

    if (m_total_score >= this->CharToFloat(this->GetConfig("score_for_spam_max_hit")))    
    {
      DropConnection("Message rejected by domain policy. THIS IS SPAM","rfc554");
      this->WriteLog(LOGL1, this->Format("THIS IS SPAM Rejected for MAX HIT: %.3f cl-> %s",m_total_score),"SYS");
      return;    
     }
			 
    if (this->GetSessionProperty() & LD_ED_MAR_SUBJECT)
    {
	this->ModifyHeaderSubject("[" + this->GetConfig("x_subject","HEADER_MSG") + "]");	
	this->WriteLog(LOGL1, this->Format("THIS IS SPAM %.3f Subject: [" + this->GetConfig("x_subject","HEADER_MSG") + "]",m_total_score),"SYS");

     } 
     else  if (this->GetSessionProperty() & LD_ED_MAR_HEADER)
    {
        this->WriteHeaderMessage(this->GetConfig("x_caronte_spam","HEADER_MSG"));
	this->WriteLog(LOGL1, this->Format("THIS IS SPAM %.3f " + this->GetConfig("x_caronte_spam","HEADER_MSG") ,m_total_score),"SYS");

    } 
    else  if (this->GetSessionProperty() & LD_ED_MAR_REJECT)
    {
      DropConnection("Message rejected by domain policy. THIS IS SPAM","rfc554");
      this->WriteLog(LOGL1, this->Format("THIS IS SPAM %.3f cl-> %s",m_total_score),"SYS");
      return;
     }
   
   } else {
          this->StatisticValue("f1tot_msg_ham",1,0,1,MOREMORE);
          this->SetGlobalVariable("notify_email_is","HAM");
           }

///////header write
  if (this->GetConfig("x_rfc_mailfrom","HEADER_MSG") != "")
   this->WriteHeaderMessage(this->GetConfig("x_rfc_mailfrom","HEADER_MSG") + m_rfc_mailfrom);

  if (this->GetConfig("x_id_connection","HEADER_MSG") != "")
   this->WriteHeaderMessage(this->GetConfig("x_id_connection","HEADER_MSG") + this->Format("%d",m_id_connection));

  if (this->GetConfig("x_relay","HEADER_MSG") != "")
   this->WriteHeaderMessage(this->GetConfig("x_relay","HEADER_MSG") + this->Format("%d",m_relay));

  if (this->GetConfig("x_rfc_ip","HEADER_MSG") != "")
   this->WriteHeaderMessage(this->GetConfig("x_rfc_ip","HEADER_MSG") + m_ip_client);

  if (this->GetConfig("x_rfc_helo","HEADER_MSG") != "")
   this->WriteHeaderMessage(this->GetConfig("x_rfc_helo","HEADER_MSG") + m_helo);

  if (this->GetConfig("x_wbl","HEADER_MSG") != "")
  {
   string xs = "";
   if (m_wbl == 0)
       xs = "WHITE";
   else if (m_wbl == 1)
       xs = "BLACK"; //this is SPAMLOVER !!!!!
   else
       xs = "NONE";
   this->WriteHeaderMessage(this->GetConfig("x_wbl","HEADER_MSG") + xs);
  }

  if (this->GetConfig("x_total_score","HEADER_MSG") != "")
   this->WriteHeaderMessage(this->GetConfig("x_total_score","HEADER_MSG") + this->Format("%f",m_total_score));

  if (this->GetConfig("x_bayes_res","HEADER_MSG") != "")
   this->WriteHeaderMessage(this->GetConfig("x_bayes_res","HEADER_MSG") + m_bayes_header_msg);

  if (this->GetConfig("x_alwl","HEADER_MSG") != "" && m_alwl)
    this->WriteHeaderMessage(this->GetConfig("x_alwl","HEADER_MSG") + "true");

  if (this->GetConfig("x_spf","HEADER_MSG") != "")
    this->WriteHeaderMessage(this->GetConfig("x_spf","HEADER_MSG") + this->SPFResultString(m_spf_result));

  if (this->GetConfig("x_phishing","HEADER_MSG") != "")
    this->WriteHeaderMessage(this->GetConfig("x_phishing","HEADER_MSG") + m_phishing_header_msg);

  Reset();

}


// CACHE SCRIPT for delete e run(0);
void OnDestroyThis()
{
  if (this != NULL)
    delete this;
  this = NULL;

}
